#version 330 core

const float PI = 3.1415926535897932384626433832795;

in vec2 uv;
in float dist;
in vec4 rgbaFog;
in float fogAmount;


out vec4 outColor;

uniform int riftIndex;
uniform sampler2D primaryFb;
uniform sampler2D depthTex;
uniform vec2 invFrameSize;
uniform float counter;
uniform float counterSmooth;

uniform vec3 projectilePrimaryColor;
uniform float u_time;

#include noise2d.ash
#include fogandlight.fsh


void main()
{
	float x = gl_FragCoord.x * invFrameSize.x;
	float y = gl_FragCoord.y * invFrameSize.y;
	
	float z1 = linearDepth(texture(depthTex, vec2(x,y)).r); //depth from gbuffer depth, a float32 texture
	float z2 = linearDepth(gl_FragCoord.z);
	

	float aDiff = max(0, z2 - z1) * 10; // Makes the shader appear over all blocks.
	// float aDiff = max(0, z2 - z1) * 10000; //Makes the shader disappear in solid blocks.
	if (aDiff > 2) discard;
	
	float f = length(uv - 0.5) * 2;

	// Outer alpha mask for edge transparency:
    float alphaOuterMask = 1.0 - smoothstep(0.3, 0.75, f); // Outer radius mask

    // Inner alpha mask for center transparency:
    float alphaInnerMask = smoothstep(0.2, 0.25, f); // Inner radius mask (adjust 0.2 for inner size)
	    
	// Black outline for the inner ring in alphaOuterMask:
    float innerRingOutlineMask = smoothstep(0.25, 0.3, f) * (1.0 - smoothstep(0.3, 0.35, f)); // Defines inner ring outline range


	// Secondary outline mask
    float outlineMask = smoothstep(0.45, 0.5, f) * (1.0 - smoothstep(0.5, 0.55, f)); // Defines the outline range




	float noise = 
		cnoise2(vec2(gl_FragCoord.x / 300, gl_FragCoord.y / 300 - counter / 3))  / 50.0
		+ cnoise2(vec2(gl_FragCoord.x / 200, gl_FragCoord.y / 200 - counter / 4))  / 75.0
		+ cnoise2(vec2(gl_FragCoord.x / 2, gl_FragCoord.y / 2 - counter)) / 200.0
	;
	
	vec4 col = texture(primaryFb, vec2(x, y) + noise);
	
	


	
	float seed = 1/1000.0 + counterSmooth / 1000.0;
	// Makes the outer circle effect
	//float spikeNoise = cnoise2(vec2(riftIndex, f * counterSmooth/10.0)) + cnoise2(vec2(riftIndex + 4, f * counterSmooth/10000.0)) / 200.0;
	float spikeNoise = cnoise2(vec2(riftIndex, f * counterSmooth/1.0)) + cnoise2(vec2(riftIndex + 4, f * counterSmooth/10.0)) / 150.0;
	
	float angle = mod(atan(uv.y - 0.5, uv.x - 0.5) + spikeNoise, 2*3.14159);
	

	
	
	
	float k = cnoise2(vec2(angle * 20, seed))/4 + cnoise2(vec2(angle * 5, seed))/4 + cnoise2(vec2(seed, angle));
	
	k = k / 2 + 10;
	k = (k - 0.2) * 0.075;
	
	
	
	float b = pow(1.2 - f * k, 1.2);
	b *= pow(1 - f, 0.01);
	col.a = clamp(b, 0, 1);
	col.a = pow(col.a, 4);
	col.a = clamp(col.a - aDiff, 0, 1);
	
	col.a -= clamp((dist * (1 + fogAmount/2.0) - 50) / 40, 0, 0.7 + fogAmount * 0.3);
	



	// Combine both alpha masks
    col.a *= alphaOuterMask * alphaInnerMask;

	// Apply black outline
    //if (outlineMask > 0.0) {
    //    col.rgb = vec3(0.0); // Set color to black for the outline
    //    col.a = outlineMask; // Set the alpha for the outline
    //}

	// Apply the black outline to the inner ring
    //if (innerRingOutlineMask > 0.0) {
    //    col.rgb = vec3(0.0); // Black outline
    //    col.a = innerRingOutlineMask; // Alpha for outline visibility
    //}



	col.a = clamp(col.a, 0, 1);
    col.a = pow(col.a, 4);
    col.a = clamp(col.a - aDiff, 0, 1);

    col.a -= clamp((dist * (1 + fogAmount / 2.0) - 50) / 40, 0, 0.7 + fogAmount * 0.3);




	vec2 coord = gl_FragCoord.xy;

	float sin_factor = sin(u_time);
    float cos_factor = cos(u_time);

	coord = vec2((coord.x - 0.5) * (gl_FragCoord.x / gl_FragCoord.y), coord.y - 0.5) * mat2(cos_factor, sin_factor, -sin_factor, cos_factor);

	coord += 0.5;

	if (col.a < 0.02) discard;
	
	vec3 rust = vec3(
			(col.r * 0.393) + (col.g * 0.769) + (col.b * 0.189),
			(col.r * 0.349) + (col.g * 0.686) + (col.b * 0.168),
			(col.r * 0.272) + (col.g * 0.534) + (col.b * 0.131)
	);
	
	float fg = 1 + clamp(f * 20 - 2, 0.13, 1) * cnoise2(vec2(angle*20, seed));
	
	rust.r *= fg;
	rust.g /= fg;
	
	

	rust = vec3(
	projectilePrimaryColor.r,
	projectilePrimaryColor.g,
	projectilePrimaryColor.b
	);
	
	//float gdiff = min(col.g, 0.1);
	//float bdiff = min(col.b, 0.1);
	//rust.g -= gdiff;
	//rust.b -= bdiff;
	//rust.r += gdiff + bdiff;

	
	//col.rgb *= 1.5; // Increase the multiplier (e.g., 1.5) to make the ring brighter
	col.rgb = mix(col.rgb, rust, 1);
	col.rgb /= 1;
	
	outColor = applyFog(col, fogAmount);
}