using System;
using Vintagestory.API.Common;
using Vintagestory.API.Server;
using Vintagestory.API.MathTools;
using Vintagestory.API.Config;

namespace ShiggleShagglesMods
{
    public class BedRespawner : ModSystem
    {
        private ICoreServerAPI serverApi;
        public static BedRespawnerConfig config;

        public override void StartServerSide(ICoreServerAPI api)
        {
            this.serverApi = api;
            TryToLoadConfig(api);
            api.Event.DidUseBlock += OnUseBlock;
        }

        private void OnUseBlock(IServerPlayer byPlayer, BlockSelection blockSel)
        {
            if (blockSel == null) return;

            Block usedBlock = this.serverApi.World.BlockAccessor.GetBlock(blockSel.Position);
            if (usedBlock.Code.Path.StartsWith("bed-"))
            {
                if(usedBlock.Code.Path.StartsWith("bed-hay-") && config.HayBedRespawn==false) return;
                PlayerSpawnPos spawnPos = new PlayerSpawnPos(
                    blockSel.Position.X,
                    blockSel.Position.Y,
                    blockSel.Position.Z
                );
                byPlayer.SetSpawnPosition(spawnPos);
                byPlayer.SendMessage(GlobalConstants.GeneralChatGroup, "Set new respawn point", EnumChatType.Notification);
            }
        }

        private void TryToLoadConfig(ICoreAPI api)
        {
            try
            {
                config = api.LoadModConfig<BedRespawnerConfig>("BedRespawnerConfig.json") ?? new BedRespawnerConfig();
                api.StoreModConfig(config, "BedRespawnerConfig.json");
            }
            catch (Exception e)
            {
                api.Logger.Error("Could not load config! Loading default settings instead.");
                api.Logger.Error(e);
                config = new BedRespawnerConfig();
            }
        }
    }
    
    public class BedRespawnerConfig
    {
        public bool HayBedRespawn = false;
    }
}
