using System;
using System.Text;
using System.Reflection;
using System.Collections.Generic;
using Vintagestory.API.Common;
using Vintagestory.API.Common.Entities;
using Vintagestory.API.Config;
using Vintagestory.API.Datastructures;
using Vintagestory.API.MathTools;
using Vintagestory.GameContent;
using Vintagestory.API.Client;
using Vintagestory.API.Server;
using System.Runtime;
using CraftableCompanion;
using Vintagestory.API.Util;

namespace CraftableCompanion
{


    public class CraftableCompanion : ModSystem
    {
        /*public override bool ShouldLoad(EnumAppSide forSide)
        {
            return true;
        }*/

        public override void Start(ICoreAPI api)
        {
            api.RegisterEntityBehaviorClass ("craftablecompanioncommandable", typeof(EntityBehaviorCraftableCompanionCommandable));
            api.RegisterEntityBehaviorClass ("craftablecompanionopenablecontainer", typeof(EntityBehaviorCraftableOpenableContainer));
            api.RegisterEntity ("EntityCraftableCompanion", typeof(EntityCraftableCompanion));
        }
    }






	public class EntityCraftableCompanion : EntityGlowingAgent
	{
		/*private double mul1;

		private double mul2;*/

/*		protected byte[] lightHsv = new byte[3] {
			34,
			5,
			5
		};*/

		/*protected byte[] lightHsv = new byte[3] {
			10,
			5,
			10
		};*/

		public bool lightEmitting;

		private float repairCooldown = 0f;
		private const float repairCooldownDuration = 1f; // seconds

  		private bool ownershipAssigned = false; // used to track some state in ownership ticking logic

		/*private int cnt;*/

		public override byte[] LightHsv {
			get {
				if (!lightEmitting) {
					return null;
				}
				return base.LightHsv;
			}
		}

		public override void OnGameTick(float dt)
		{
		    base.OnGameTick(dt);

		    // cooldown countdown runs on the server only
		    if (Api.Side == EnumAppSide.Server && repairCooldown > 0f)
		    {
		        repairCooldown -= dt;
		        if (repairCooldown < 0f) repairCooldown = 0f;
		    }

		    var sapi = Api as ICoreServerAPI;
		    var ownershipSystem = Api.ModLoader.GetModSystem<ModSystemEntityOwnership>();

		    // --- purge ownership if dead ---
		    if (!this.Alive && ownershipAssigned && Api.Side == EnumAppSide.Server)
		    {
		        if (ownershipSystem != null)
		        {
		            //sapi.Logger.Warning("[RepairableLocust] clearing ownership because entity is dead");
		            ownershipSystem.RemoveOwnership(this);
		        }
		        ownershipAssigned = false;
		    }

		    // --- reset ownership flag if alive but has no owner ---
		    if (this.Alive && ownershipAssigned && Api.Side == EnumAppSide.Server)
		    {
		        if (ownershipSystem != null)
		        {
		            var ownerTree = this.WatchedAttributes.GetTreeAttribute("ownedby");
		            string ownerUid = ownerTree?.GetString("uid", null);

		            if (string.IsNullOrEmpty(ownerUid))
		            {
		                //sapi.Logger.Warning("[RepairableLocust] entity alive but has no owner, resetting ownershipAssigned=false");
		                ownershipAssigned = false;
		            }
		        }
		    }

		    // Ownership assignment logic (server side only, skip if repairing or on cooldown)
		    if (!ownershipAssigned && Api.Side == EnumAppSide.Server && repairCooldown <= 0f && this.Alive)
		    {
		        var guardBehavior = GetBehavior<EntityBehaviorCraftableCompanionCommandable>();
		        if (guardBehavior != null)
		        {
		            // Access the entity’s WatchedAttributes
		            string ownerUid = guardBehavior.entity.WatchedAttributes.GetString("guardOwnerUid", null);

		            if (string.IsNullOrEmpty(ownerUid))
		                ownerUid = guardBehavior.entity.WatchedAttributes.GetString("guardedPlayerUid", null);

		            if (!string.IsNullOrEmpty(ownerUid))
		            {
		                IServerPlayer owner = sapi.World.PlayerByUid(ownerUid) as IServerPlayer;
		                EntityAgent ownerEntity = owner?.Entity as EntityAgent;

		                if (ownerEntity != null)
		                {
		                    //sapi.Logger.Warning("[RepairableLocust] clearing previous ownership (if any) and claiming ownership for " + owner.PlayerName);

		                    if (ownershipSystem != null)
		                    {
		                        // purge any previous ownership before claiming
		                        ownershipSystem.RemoveOwnership(this);
		                        ownershipSystem.ClaimOwnership(this, ownerEntity);
		                        ownershipAssigned = true;
		                    }
		                    //else
		                    //{
		                    //    sapi.Logger.Warning("[RepairableLocust] ownershipSystem is null - cannot change ownership");
		                    //}
		                }
		                //else
		                //{
		                //    sapi.Logger.Warning("[RepairableLocust] locust owner entity is null, cannot run claim logic!");
		                //}
		            }
		        }
		    }
		}


		public override void OnInteract (EntityAgent byEntity, ItemSlot itemslot, Vec3d hitPosition, EnumInteractMode mode)
		{
			//Baisc revove with spear logic
		    if (!this.Alive)
		    {
		        if (!itemslot.Empty && itemslot.Itemstack != null && (itemslot.Itemstack.Collectible.Code.Path == "spear-generic-hacking" || itemslot.Itemstack.Collectible.Code.Path.Contains("wrench-")))
		        {
		        	if (repairCooldown > 0f)
		            {
		                return; // to stop multiple sounds.
		            }
		            // Revive logic
		            Revive();
		            this.World.PlaySoundAt(new AssetLocation("game:sounds/player/messycraft"), this);
		            this.World.PlaySoundAt(new AssetLocation("repairablelocust:sounds/automatonrepair"), this);
		            repairCooldown = repairCooldownDuration;
		            ownershipAssigned = false;//Ownership tries to clear dead entities so this causes it to set again after revive

		            return; // Prevent base interaction
		        }
		    }

			if (!itemslot.Empty && itemslot.Itemstack != null && (itemslot.Itemstack.Collectible.Code.Path == "spear-generic-hacking" || itemslot.Itemstack.Collectible.Code.Path.Contains("wrench-")) && this.Alive)
		    {
	            if (repairCooldown > 0f)
	            {
	                return; // prevent any real processing if on cool down, still blocking spear damage.
	            }
	            repairCooldown = repairCooldownDuration;
		        DamageSource HealingDamage = new DamageSource();
		        HealingDamage.Type = EnumDamageType.Heal;
		        this.ReceiveDamage(HealingDamage, 300f);
		        this.World.PlaySoundAt(new AssetLocation("craftablecompanion:sounds/automatonrepair"), this);
		    }else
			if (byEntity.Controls.Sprint && byEntity.Controls.RightMouseDown && !byEntity.Controls.Sneak){
				lightEmitting = !lightEmitting;
				this.World.PlaySoundAt(new AssetLocation("craftablecompanion:sounds/lighttoggle"), this);
			}
			else
				base.OnInteract (byEntity, itemslot, hitPosition, mode);
		}




	}






































}