# Bricklayers

"Bricks and stones may break bones."

This Vintage Story mod adds new blocks and recipes to the
game, as well as a new late-game play mechanic:

## Glazed Ceramics & Glassmaking

Create colored glazings and coat bricks, planters, flowerpots and bowls
with them. You can even apply patterns to glazed planters and
flowerpots.

The glass colors can then also be used to smelt colored glass.

The whole process adds a new workflow: you will need automation,
a lot of resources and time, but the results will be rare and
wonderful items for your collection, to decorate or trade with others.

### Colored Glass

There are two new glass colors: *black* and *orange* and two new glass types:
*dark* and *opaque*. Dark glass has a richer color, and blocks a bit of
light, while opaque glass is not transparent, reflective and blocks even more light.

In addition, all vanilla glass colors are now available in all five variants:
*milky*, *quartz*, *smoky*, *dark* and *opaque*.

Also, you can now chisel any glass block, regardless of type or color.

## Colored Clay & Porcelain

* Craft different clay colors by combining blue-grey or fire clay with coloring agents.
* Craft bone porcelain from bone ash, light clay and stone powder.
* Craft colored pottery: planters, flowerpots, watering cans, cups, mugs, crocks and storage vessels

### Porcelain and Clay Tiles

Craft tiles from porcelain or colored clay and use them to decorate or create
tile blocks for chiseling.

## New Blocks & Recipes

This mod also adds usefull recipes to recycle or transform blocks.
And there are new stone brick blocks and colors.

You can combine slabs into full blocks, saw full blocks into slabs,
and recycle blocks back into stones or bricks.

You can use a saw to cut polished slabs into stone tiles, and build hollow,
cheaper versions of polished stone blocks from these tiles.

You can divide stonepath blocks or stonepath stairs into slabs,
or combine stonepath slabs back into full stonepath blocks.

There are new colored clay blocks for you to use in building and chiseling.
And you can use a saw to create hardened clay slabs from hardened clay blocks.

## More Information

You can find more information and pretty pictures at our [Wiki](https://gitlab.com/codesmiths/vs_bricklayers/-/wikis/home).

Please see our [Roadmap](https://gitlab.com/codesmiths/vs_bricklayers/-/wikis/Roadmap) for
information about planned features.

We hope you enjoy our work.

~Phiwa & Tels

# Download

* The mod from [Official Vintage Story ModDB](https://mods.vintagestory.at/bricklayers)
* You also need to install [Expanded Matter](https://mods.vintagestory.at/em)
* The source code can be found on [Gitlab](https://gitlab.com/codesmiths/vs_bricklayers/-/releases)

# Installation

This mod should work in existing worlds. If in doubt, please create a new world.

  <u>**Make a backup of your savegame and world before trying this mod!**</u>

# Features

## New Mechanic: Glazing and Glassmaking

* Crush, grind and mix items into Frit (glass colors)
* Sinter (bake) and grind Frits, add them to glazing bases to create glazes
* Glaze bricks, bowls, flowerpots and even planters to color them
* Create and apply patterns to planters and flowerpots
* Form new brick blocks from glazed clay bricks

## New Glass Colors and Types

* Luminous glass in three brightness levels and various colors and types
* New glass color: black
* New glass types: dark and opaque
* All vanilla glass colors are available as: milky, quartz, smoky, dark and opaque

## New Blocks & Items

* Polish stonebricks into small stone bricks
* Craft stonebrick blocks, slabs and stairs with smaller bricks
* Polish obsidian into blocks and slabs
* Saw polished stone into large stone tiles
* Use stone tiles for decoration or to build stone tile blocks
* Drinking mugs made from unglazed or glazed clay.

## Block transformations

* Saw cobble, stonebrick, claybrick and shingle blocks into slabs
* Combine cobble slabs with clay into full cobble blocks
* Combine two clay or stone brick slabs with mortar into full brick blocks
* Combine two stonepath slabs into stonepath blocks
* Combine two shingle slabs into full shingle blocks
* Combine three stonepath slabs into stonepath stairs
* Combine three shingle slabs into shingle stairs
* You can craft chimneys also with mortar (to be consistent with other brick blocks)
* You can craft brick stairs consistent with cobble stairs (edge on the top-left corner)

## Recycling

* Use a hammer or pickaxe to break down cobble blocks or slabs into rocks
* Use a hammer or pickaxe to break down shingle blocks, slabs or stairs into shingles
* Use a saw to saw clay or stone brick blocks, slabs, stairs or chimneys back into bricks
* Use a saw to saw shingle blocks, slabs or stairs back into shingles
* Use a shovel to break stonepath blocks or stairs back into stonepath slabs

# Languages

* English (100%)
* German (100%)
* Russian (70%)
* Spanish (70%)
* Brasilian-Portugese (70%)

If you would like to translate this mod into other languages, please [contact us](https://gitlab.com/codesmiths/vs_bricklayers/-/wikis/Contact).

# Known issues

The vanilla clay brick blocks, slabs, stairs and chimneys have yields inconsistent with f.i. cobble stairs.
In addition, brick slabs need 5 bricks, compared to cobble slabs which only need 3 stones.
Thus the recycling of the various brick blocks yields different brick counts than recycling rock based blocks.

Empty liquid containers like bowls, jugs or mugs cannot be dropped into the barrel input slot
to glaze them. You need to **shift-click** these into the barrel.

# Changes and Roadmap

Please see the [Changelog](Changelog) for the changes in the latest release.

The full [Roadmap](https://gitlab.com/codesmiths/vs_bricklayers/-/wikis/Roadmap) page contains all the planned or possible features.

If you have any ideas, or know about features that already done in another mod, then we
love [to hear from you](https://gitlab.com/codesmiths/vs_bricklayers/-/wikis/Contact).

# Signature key

All our releases are signed using PGP (GnuPG) and their integrity can be verified by using the public key as published
[on the wiki](https://gitlab.com/codesmiths/vs_bricklayers/-/wikis/Signing-key).

